import React from 'react';
import { storiesOf } from '@storybook/react';
import { CenterDecorator } from 'helpers';

import Button from './';

storiesOf('Button', module)
  .addDecorator(CenterDecorator)
  .add('Primary', () => <Button label="Continue" />)
  .add('Primary Link', () => <Button label="Continue" href="https://www.carbonweb.co" />)
  .add('Primary Loading', () => <Button isLoading label="Continue" />)
  .add('Primary Disabled', () => <Button disabled label="Continue" />)
  .add('Primary Iconed', () => <Button isIconed label="Continue" />)
  .add('Primary Iconed Loading', () => <Button isIconed isLoading label="Continue" />)
  .add('Primary Iconed Disabled', () => <Button isIconed disabled label="Continue" />)
  .add('Secondary', () => <Button secondary label="Back" />)
  .add('Secondary Only Icon', () => <Button secondary isIconed />);

