import React from 'react';
import PropTypes from 'prop-types';
import cn from 'classnames';

import ArrowIcon from 'components/Icons/ArrowIcon';

import style from './Button.module.scss';

const Button = ({className, disabled, isIconed, isLoading, secondary, label, onClick, href, ...props}) => {
  const classes = cn(className, style.Button, {
   [style.IsDisabled]: disabled,
   [style.IsLoading]: isLoading,
   [style.Secondary]: secondary,
   [style.HasNolabel]: !label
  });

  const Button = href ? "a" : "button";

  return (
    <Button
      className={classes}
      disabled={disabled}
      href={href}
      target={href && "_blank"}
      rel={href && "noopener noreferrer"}
      onClick={onClick}
      {...props}
    >
      {isLoading ? <span className={cn(style.Spinner, label && style.ButtonContent)} />
        : (label && <span className={style.ButtonContent}>{label}</span>)}

      {isIconed && <span className={style.IconWrapper}>
        <ArrowIcon />
      </span>}
    </Button>
  );
};

Button.propTypes = {
  className: PropTypes.string,
  disabled: PropTypes.bool,
  isIconed: PropTypes.bool,
  isLoading: PropTypes.bool,
  secondary: PropTypes.bool,
  onClick: PropTypes.func,
  label: PropTypes.string,
  href: PropTypes.string
};

export default Button;
