import React from 'react';
import { storiesOf } from '@storybook/react';
import { CenterDecorator } from 'helpers';

import HouseIcon from 'components/Icons/HouseIcon';
import Checkbox from './';

storiesOf('Checkbox', module)
  .addDecorator(CenterDecorator)
  .add('Active', () => <Checkbox name="1" label="Yes" id="one" />)
  .add('Active Selected', () => <Checkbox name="2" label="Yes" id="two" isSelected />)
  .add('Disabled', () => <Checkbox name="3" label="Yes" id="three" disabled />)
  .add('Active with Icon', () => <Checkbox name="4" label="Yes" id="four" icon={<HouseIcon />} />)
  .add('Active with Icon Selected', () => <Checkbox name="5" label="Yes" id="five" icon={<HouseIcon />}  />)
  .add('Active with Icon Disabled', () => <Checkbox name="6" label="Yes" id="six" icon={<HouseIcon />} disabled />);
