import React from 'react';
import cn from 'classnames';
import PropTypes from 'prop-types';

import style from './Checkbox.module.scss';

const Checkbox = ({className, disabled, name, id, label, isSelected, icon, ...props}) => {
  const classes = cn(className, style.Checkbox, {
    [style.IsIconed]: icon,
    [style.IsDisabled]: disabled,
    [style.IsSelected]: isSelected
  });

  return (
    <label htmlFor={id} className={classes}>
      <input
        type="checkbox"
        name={name}
        id={id}
        defaultChecked={isSelected}
        disabled={disabled}
        {...props}
      />

      <div className={style.CheckboxControl} />
      {icon && icon}
      {label}
    </label>
  );
};

Checkbox.propTypes = {
  name: PropTypes.string,
  id: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  className: PropTypes.string,
  disabled: PropTypes.bool,
  icon: PropTypes.node,
  isSelected: PropTypes.bool
};

export default Checkbox;
