import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { ChromePicker } from 'react-color';

import HandIcon from 'components/Icons/HandIcon';

import style from './ColorPicker.module.scss';

const DEFAULT_COLOR = '#fff';

class ColorPicker extends Component {
  constructor(props) {
    super(props);

    this.state = {
      isOpen: false,
      selectedColor: this.props.currentColor || DEFAULT_COLOR
    }
  }

  toggleColorPickerControls = () => {
    this.setState(prevState => ({
      isOpen: !prevState.isOpen
    }));
  };

  handleColorChange = ({ hex}) => {
    this.setState({
      selectedColor: hex
    });

    this.props.onClick({id: this.props.id, hex});
  };

  closePopover = () => {
    this.setState({
      isOpen: false
    });
  };

  render() {
    const { selectedColor, isOpen } = this.state;
    const isDefaultSelection = selectedColor === DEFAULT_COLOR;
    const { id } = this.props;

    return (
      <div className={style.ColorPickerWrapper} id={id}>
        <button
          className={style.ColorPickerButton}
          style={{ background: selectedColor }}
          onClick={this.toggleColorPickerControls}
        >
          {isDefaultSelection && (<HandIcon />)}
        </button>

        {!isDefaultSelection && (
          <div className={style.ColorStatusBar}>
            {selectedColor}
          </div>
        )}

        {isOpen && (
          <div className={style.ColorPickerPopover}>
            <div className={style.ColorPickerOutbound} onClick={this.closePopover} />
            <ChromePicker
              color={selectedColor}
              onChangeComplete={this.handleColorChange}
              disableAlpha
            />
          </div>
        )}
      </div>
    );
  }
}

ColorPicker.propTypes = {
  id: PropTypes.string,
  onClick: PropTypes.func,
  currentColor: PropTypes.string
};

export default ColorPicker;
