import React from 'react';
import PropTypes from 'prop-types';
import cn from 'classnames';

import styles from './FlexContainer.module.scss';

const FlexContainer = ({ children, className, flexAlign }) => {
  const containerClasses = cn(className, [styles[flexAlign]], styles.FlexContent, {});

  return (
    <div className={containerClasses}>
      {children}
    </div>
  );
};

FlexContainer.defaultProps = {
  flexAlign: 'Start'
};

FlexContainer.propTypes = {
  children: PropTypes.oneOfType([
    PropTypes.arrayOf(PropTypes.node),
    PropTypes.node
  ]).isRequired,
  className: PropTypes.string,
  flexAlign: PropTypes.oneOf(['Start', 'Between', 'Around', 'End'])
};

export default FlexContainer;
