import React from 'react';
import PropTypes from 'prop-types';

import styles from './FormGroup.module.scss';

const FormGroup = ({ children, hasSmallerMargin }) => {
  return (
    <div className={hasSmallerMargin ? styles.SmallerFormGroup : styles.FormGroup}>
      {children}
    </div>
  );
};

FormGroup.propTypes = {
  children: PropTypes.oneOfType([
    PropTypes.arrayOf(PropTypes.node),
    PropTypes.node
  ]).isRequired,
  hasSmallerMargin: PropTypes.bool
};

export default FormGroup;
