import React from 'react';
import { storiesOf } from '@storybook/react';
import { MaxWidthDecorator } from 'helpers';

import Input from 'components/Input';
import Timezone from 'components/Input/Timezone';

storiesOf('Input', module)
  .addDecorator(MaxWidthDecorator)
  .add('Basic Input', () => (
    <Input placeholder="Some placeholder" />
  ))
  .add('Input with Label', () => (
    <Input label="Some label" id="some-label" placeholder="Labelled Input" />
  ))
  .add('Currency Input', () => (
    <Input isCurrencyType placeholder="eg. 2019" />
  ))
  .add('Currency Input with Interval', () => (
    <Input isCurrencyType isMonthlyInterval placeholder="eg. 2019" />
  ))
  .add('Input with error', () => (
    <Input placeholder="Ooopsie!" error="Oopsie! Something went wrong!" />
  ))
  .add('Timezone Input', () => (
    <Timezone />
  ))
  .add('Timezone Input with label', () => (
    <Timezone label="Select Timezone" />
  ));
