import React from 'react';
import PropTypes from 'prop-types';

import TimezonePicker from 'react-bootstrap-timezone-picker';

import styles from './Input.module.scss';

const Timezone = ({ label, placeholder, value, handleOnChange }) => {
  return (
    <div>
      {label && (
        <p className={styles.InputLabel}>
          {label}
        </p>
      )}

      <TimezonePicker
        absolute={false}
        className='TimezonePicker'
        placeholder={placeholder || 'Select Timezone...'}
        value={value}
        onChange={(value) => handleOnChange(value)}
      />
    </div>
  );
};

Timezone.propTypes = {
  label: PropTypes.string,
  value: PropTypes.string,
  handleOnChange: PropTypes.func,
  placeholder: PropTypes.string
};

export default Timezone;
