import React from 'react';
import cn from 'classnames';
import PropTypes from 'prop-types';

import styles from './Input.module.scss';

const Input = ({
   placeholder,
   isCurrencyType,
   type,
   isMonthlyInterval,
   label,
   id,
   error,
   onChange,
   value,
   required,
   ...props
}) => {
  const inputClasses = cn(styles.RealInput, {
    [styles.IsInvalid]: error
  });

  return (
    <div className={styles.InputWrapper} {...props}>
      {(label && id) && (
        <label className={styles.InputLabel} htmlFor={id}>
          {label}
        </label>
      )}

      <div className={styles.InputArea}>
        {isCurrencyType && (<span className={styles.InputPrefixSuffix}>$</span>)}

        <input
          className={inputClasses}
          placeholder={placeholder}
          type={isCurrencyType ? 'number' : type}
          id={id}
          onChange={(e) => onChange(id, e.target.value)}
          defaultValue={value}
          required={required}
        />

        {isMonthlyInterval && (<span className={styles.InputPrefixSuffix}>Per Month</span>)}
      </div>

      {error && (
        <p className={styles.ErrorMessage}>{error}</p>
      )}
    </div>
  );
};

Input.defaultProps = {
  type: 'text',
  isCurrencyType: false,
  isMonthlyInterval: false
};

Input.propTypes = {
  placeholder: PropTypes.string.isRequired,
  type: PropTypes.string,
  isCurrencyType: PropTypes.bool,
  required: PropTypes.bool,
  isMonthlyInterval: PropTypes.bool,
  label: PropTypes.string,
  id: PropTypes.string,
  error: PropTypes.any,
  onChange: PropTypes.func,
  value: PropTypes.string
};

export default Input;
