import React from 'react';
import PropTypes from 'prop-types';
import { withRouter } from 'react-router-dom';
import { connect } from 'react-redux';

import Button from 'components/Button';
import Progress from 'components/Progress';

import style from './Navbar.module.scss';

const BottomNav = ({ progressLabel, buttonLabel, nextButtonAction, prevButtonAction, disableButton, location, entryPath, history, nextPath }) => {

  const goToNext = () => {
    nextButtonAction ? nextButtonAction() : history.push(nextPath);
  };

  const goToBack = () => {
    history.goBack();
    prevButtonAction && prevButtonAction();
  };

  return (
    <div className={style.BottomNavigation}>
      <div className={style.BottomNavigationContainer}>

      <span className={style.AssistanceHelp}>
        For Assistance Call:
        {' '}
        <a href="tel:2166662522">216-666-2522</a>
      </span>

        <div className={style.StepsIndicator}>
          <Progress label={progressLabel} />
        </div>

        <div className={style.ActionsWrapper}>
          {location.pathname !== entryPath && (
            <Button
              isIconed
              secondary
              onClick={goToBack}
            />
          )}

          <Button
            isIconed
            label={buttonLabel}
            disabled={disableButton}
            onClick={goToNext}
          />
        </div>
      </div>
    </div>
  );
};

const mapStateToProps = state => {
  return {
    entryPath: state.mainFlow.entryPath,
    nextPath: state.mainFlow.nextPath
  }
};

BottomNav.defaultProps = {
  progressLabel: 'This form will take you only couple of minutes!',
  buttonLabel: 'Continue'
};

BottomNav.propTypes = {
  progressLabel: PropTypes.string,
  buttonLabel: PropTypes.string,
  nextPath: PropTypes.string,
  prevButtonAction: PropTypes.func,
  nextButtonAction: PropTypes.func,
  disableButton: PropTypes.bool,
  location: PropTypes.object,
  history: PropTypes.object,
  entryPath: PropTypes.string
};

export default withRouter(connect(
  mapStateToProps,
  null
)(BottomNav));
