import React from 'react';

import Logotype from 'assets/carbonweb.svg';

import style from './Navbar.module.scss';

const TopNav = () => (
  <div className={style.TopNavigation}>
    <div className={style.NavigationContainer}>
      <img className={style.NavigationLogotype} src={Logotype} alt="CarbonWeb" />

      <p className={style.NavigationHeader}>
        <span className={style.AssistanceCall}>
          For Assistance Call:
          {' '}
          <a href="tel:2166662522">216-666-2522</a>
        </span>
        <a
          rel="noreferrer noopener"
          href="https://www.carbonweb.co"
          target="_blank"
          className={style.WebsiteLink}
        >
          Back to website
        </a>
      </p>
    </div>
  </div>
);

export default TopNav;
