import React from 'react';
import PropTypes from 'prop-types';

import Typography from 'components/Typography';

import style from './Progress.module.scss';

const Progress = ({ percentCompleted, label }) => (
  <>
    {percentCompleted && (
      <div className={style.ProgressWrapper}>
        <div className={style.ProgressBar} style={{ width: percentCompleted + '%'}} />
      </div>
    )}

    {label && (
      <Typography isGray size="Tiny">
        {label}
      </Typography>
    )}
  </>
);

Progress.propTypes ={
  percentCompleted: PropTypes.number,
  label: PropTypes.string
};

export default Progress;
