import React from 'react';
import cn from 'classnames';
import PropTypes from 'prop-types';

import style from './RadioButton.module.scss';

const RadioButton = ({className, disabled, name, id, label, isSelected, value, onClick, ...props}) => {
  const classes = cn(className, style.Radio);

  return (
    <div className={classes} onClick={onClick}>
      <input
        className={classes}
        type="radio"
        name={name}
        id={id}
        value={value}
        checked={isSelected}
        disabled={disabled}
        onChange={onClick}
        {...props}
      />

      <label htmlFor={id} className={style.RadioLabel}>{label}</label>
    </div>
  );
};

RadioButton.propTypes = {
  name: PropTypes.string.isRequired,
  value: PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
  id: PropTypes.string,
  label: PropTypes.string.isRequired,
  className: PropTypes.string,
  disabled: PropTypes.bool,
  onClick: PropTypes.func,
  isSelected: PropTypes.bool
};

export default RadioButton;
