import React from 'react';
import PropTypes from 'prop-types';
import cn from 'classnames';

import BottomNav from 'components/Navbar/BottomNav';

import style from './StepWrapper.module.scss';

const StepWrapper = ({
   children,
   progressLabel,
   buttonLabel,
   prevButtonAction,
   nextButtonAction,
   disableButton,
   isShort,
   withoutBottomNav
}) => {
  const wrapperClasses = cn(style.StepContent, {
    [style.IsShort]: isShort
  });

  return (
    <>
      <div className={style.StepsWrapper}>
        <div className={wrapperClasses}>
          {children}
        </div>
      </div>

      {!withoutBottomNav && (
        <BottomNav
          progressLabel={progressLabel}
          buttonLabel={buttonLabel}
          prevButtonAction={prevButtonAction}
          nextButtonAction={nextButtonAction}
          disableButton={disableButton}
        />
      )}
    </>
  );
};

StepWrapper.propTypes = {
  children: PropTypes.oneOfType([
    PropTypes.arrayOf(PropTypes.node),
    PropTypes.node
  ]).isRequired,
  isShort: PropTypes.bool,
  withoutBottomNav: PropTypes.bool,
  progressLabel: PropTypes.string,
  buttonLabel: PropTypes.string,
  prevButtonAction: PropTypes.func,
  nextButtonAction: PropTypes.func,
  disableButton: PropTypes.bool
};

export default StepWrapper;
