import React from 'react';
import { storiesOf } from '@storybook/react';
import { CenterDecorator } from 'helpers';

import Typography from './';

storiesOf('Typography', module)
  .addDecorator(CenterDecorator)
  .add('Typography Examples', () =>
    <div style={{ textAlign: 'center' }}>
      <Typography size="Huge" weight={700} marginBottom={24}>
        Huge bold black text!
      </Typography>

      <Typography size="Medium" isGray weight={500} marginBottom={16}>
        Medium regular gray text!
      </Typography>

      <Typography weight={300} marginBottom={12}>
        Regular thin black text!
      </Typography>

      <Typography size="Small" weight={400} isGray marginBottom={8}>
        Small gray text!
      </Typography>

      <Typography size="Tiny">
        Tiny black text!
      </Typography>
    </div>
  );

