import React from 'react';
import PropTypes from 'prop-types';
import cn from 'classnames';

import style from './Typography.module.scss';

const Typography = ({ className, children, weight, isGray, size, marginBottom, ...props }) => {
  const typographySpacing = { marginBottom: marginBottom + 'px' };
  const typographyClasses = cn(className, style.Typography, {
    [style.RegularWeight]: weight <= 400,
    [style.MediumWeight]: weight > 400 && weight <= 500,
    [style.BoldWeight]: weight > 500,
    [style[size]]: true,
    [style.GrayColored]: isGray
  });

  return (
    <p
      className={typographyClasses}
      style={typographySpacing}
      {...props}
    >
      {children}
    </p>
  );
};

Typography.defaultProps = {
  size: 'Regular',
  weight: 500,
  marginBottom: 8
};

Typography.propTypes = {
  className: PropTypes.string,
  children: PropTypes.oneOfType([
    PropTypes.arrayOf(PropTypes.node),
    PropTypes.node
  ]).isRequired,
  weight: PropTypes.number,
  isGray: PropTypes.bool,
  size: PropTypes.oneOf(['Tiny', 'Small', 'Regular', 'Medium', 'Huge']),
  marginBottom: PropTypes.number
};

export default Typography;
