import React from 'react';
import { Route } from 'react-router-dom';
import { ROUTING } from 'routing';
import { Router } from 'react-router';

import { history } from 'appHistory';

import TopNav from 'components/Navbar/TopNav';

import Homepage from 'containers/Homepage';
import ConceptProduction from 'containers/ConceptProduction';
import Development from 'containers/Development';
import DevelopmentPages from 'containers/Development/DevelopmentPages';
import DevelopmentDetails from 'containers/Development/DevelopmentDetails';
import DevelopmentShop from 'containers/Development/DevelopmentShop';
import Marketing from 'containers/Marketing';
import MarketingSocialMedia from 'containers/Marketing/MarketingSocialMedia';
import MarketingAdwords from 'containers/Marketing/MarketingAdwords';
import MarketingRemarketing from 'containers/Marketing/MarketingRemarketing';
import DataManagement from 'containers/DataManagement';
import Hosting from 'containers/DataManagement/Hosting';
import HostingDetails from 'containers/DataManagement/HostingDetails';
import Domains from 'containers/DataManagement/Domains';
import DomainsRegistration from 'containers/DataManagement/DomainsRegistration';
import GSuite from 'containers/DataManagement/GSuite';
import PersonalDetails from 'containers/PersonalDetails';
import Success from 'containers/Success';

function App() {
  return (
    <Router history={history}>
      <TopNav />

      <Route path={ROUTING.INDEX} exact component={Homepage} />
      <Route path={ROUTING.CONCEPT_PRODUCTION} exact component={ConceptProduction} />
      <Route path={ROUTING.WEB_DEVELOPMENT} exact component={Development} />
      <Route path={ROUTING.WEB_DEVELOPMENT_PAGES} exact component={DevelopmentPages} />
      <Route path={ROUTING.WEB_DEVELOPMENT_DETAILS} exact component={DevelopmentDetails} />
      <Route path={ROUTING.WEB_DEVELOPMENT_SHOP} exact component={DevelopmentShop} />
      <Route path={ROUTING.DATA_MANAGEMENT} exact component={DataManagement} />
      <Route path={ROUTING.DATA_MANAGEMENT_HOSTING} exact component={Hosting} />
      <Route path={ROUTING.DATA_MANAGEMENT_HOSTING_DETAILS} exact component={HostingDetails} />
      <Route path={ROUTING.DATA_MANAGEMENT_DOMAINS} exact component={Domains} />
      <Route path={ROUTING.DATA_MANAGEMENT_DOMAINS_URL} exact component={DomainsRegistration} />
      <Route path={ROUTING.DATA_MANAGEMENT_G_SUITE} exact component={GSuite} />
      <Route path={ROUTING.MARKETING} exact component={Marketing} />
      <Route path={ROUTING.MARKETING_SOCIAL_MEDIA} exact component={MarketingSocialMedia} />
      <Route path={ROUTING.MARKETING_ADWORDS} exact component={MarketingAdwords} />
      <Route path={ROUTING.MARKETING_REMARKETING} exact component={MarketingRemarketing} />
      <Route path={ROUTING.PERSONAL_DETAILS} exact component={PersonalDetails} />
      <Route path={ROUTING.SUCCESS_PAGE} exact component={Success} />
    </Router>
  );
}

export default App;
