import React from 'react';
import { connect } from 'react-redux';
import PropTypes from 'prop-types';

import { updateCptObject } from 'stores/conceptProduction';

import withFlowManaging from 'helpers/withFlowManaging';
import { CPT_GRAPHICS, CPT_LOGO, CPT_CONTENT, CPT_PHOTO} from 'helpers/constants';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import FlexContainer from 'components/FlexContainer';
import Checkbox from 'components/Checkbox';
import GraphicIcon from 'components/Icons/GraphicIcon';
import PaintingIcon from 'components/Icons/PaintingIcon';
import CameraIcon from 'components/Icons/CameraIcon';
import DocsIcon from 'components/Icons/DocsIcon';

import commonStyles from 'containers/Common.module.scss';

function ConceptProduction({
   cptServices,
   updateCpt
}) {

  const checkboxItems = [
    {
      id: CPT_GRAPHICS,
      label: 'Custom Graphics',
      icon: <GraphicIcon />
    },
    {
      id: CPT_LOGO,
      label: 'Logo Creation',
      icon: <PaintingIcon />
    },
    {
      id: CPT_CONTENT,
      label: 'Content Creation',
      icon: <DocsIcon />
    },
    {
      id: CPT_PHOTO,
      label: 'Photography',
      icon: <CameraIcon />
    }
  ];

  return (
    <StepWrapper
      progressLabel={`Concept production: 1 / 1`}
    >
      <Typography size='Huge' weight={700} marginBottom={32}>
        Choose any of the following services:
      </Typography>

      <FlexContainer flexAlign="Between" className={commonStyles.TwoToFour}>
        {checkboxItems.map(({ id, label, icon }) => (
          <Checkbox
            key={id}
            id={id}
            label={label}
            icon={icon}
            isSelected={cptServices[id]}
            onClick={() => updateCpt({id, value: !cptServices[id]})}
          />
        ))}
      </FlexContainer>
    </StepWrapper>
  );
}

const mapStateToProps = state => {
  return {
    cptServices: state.conceptProduction.cptServices
  }
};

const mapDispatchToProps = dispatch => {
  return {
    updateCpt: payload => dispatch(updateCptObject(payload))
  }
};

ConceptProduction.propTypes = {
  cptServices: PropTypes.object,
  updateCpt: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(ConceptProduction));


