import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import withFlowManaging from 'helpers/withFlowManaging';
import { updateDataDomainsServcie } from 'stores/dataManagement';

import { isAnySelected } from 'helpers';
import {
  DATA_DOMAINS,
  DATA_DOMAINS_SSL,
  DATA_DOMAINS_SERVICES,
  DATA_DOMAINS_REGISTRATION
} from 'helpers/dmConstants';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import FlexContainer from 'components/FlexContainer';
import Checkbox from 'components/Checkbox';
import SslIcon from 'components/Icons/SslIcon';
import DomainIcon from 'components/Icons/DomainIcon';

import commonStyles from 'containers/Common.module.scss';

const checkboxItems = [
  {
    id: DATA_DOMAINS_SSL,
    label: 'SSL Certificate',
    icon: <SslIcon />
  },
  {
    id: DATA_DOMAINS_REGISTRATION,
    label: 'Domain Registration',
    icon: <DomainIcon />
  }
];

function Domains({
   domains,
   updateDataDomains
 }) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Domains: 1 / 2`}
      disableButton={isAnySelected(domains)}
    >
      <Typography marginBottom={20}>
        Choose any of the following services
      </Typography>

      <FlexContainer flexAlign="Between" className={commonStyles.StayTwo}>
        {checkboxItems.map(({id, label, icon}) => (
          <Checkbox
            key={id}
            id={id}
            label={label}
            icon={icon}
            isSelected={domains[id]}
            onClick={() => updateDataDomains({id, value: !domains[id]})}
          />
        ))}
      </FlexContainer>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  domains: state.dataManagement[DATA_DOMAINS][DATA_DOMAINS_SERVICES]
});

const mapDispatchToProps = dispatch => ({
  updateDataDomains: payload => dispatch(updateDataDomainsServcie(payload))
});

Domains.propTypes = {
  domains: PropTypes.object,
  updateDataDomains: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(Domains));

