import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateDataUrl } from 'stores/dataManagement';

import withFlowManaging from 'helpers/withFlowManaging';
import { DATA_DOMAINS, DATA_DOMAINS_URL } from 'helpers/dmConstants';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import Input from 'components/Input';

function DomainsRegistration({
  urlInput,
  updateDataUrl
}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Domains: 2 / 2`}
    >
      <Typography marginBottom={4}>
        What is your prefered website URL?
      </Typography>
      <Typography isGray size="Tiny" marginBottom={12}>
        If you don&apos;t have one, simply leave it blank
      </Typography>
      <Input
        placeholder="e.g. carbonweb.co"
        id={DATA_DOMAINS_URL}
        value={urlInput}
         onChange={(name, value) => {
           updateDataUrl({name, value})
         }}
      />
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  urlInput: state.dataManagement[DATA_DOMAINS][DATA_DOMAINS_URL]
});

const mapDispatchToProps = dispatch => ({
  updateDataUrl: payload => dispatch(updateDataUrl(payload))
});

DomainsRegistration.propTypes = {
  urlInput: PropTypes.string,
  updateDataUrl: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(DomainsRegistration));

