import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateDataGSuite } from 'stores/dataManagement';

import withFlowManaging from 'helpers/withFlowManaging';
import { DATA_GSUITE, DATA_GSUITE_CUSTOM_EMAIL, DATA_GSUITE_TRANSFER } from 'helpers/dmConstants';
import { isNotChecked } from 'helpers';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import FlexContainer from 'components/FlexContainer';
import RadioButton from 'components/RadioButton';
import FormGroup from 'components/FormGroup';

import commonStyles from 'containers/Common.module.scss';

const radioItems1 = [
  {
    name: DATA_GSUITE_CUSTOM_EMAIL,
    label: 'Yes',
    value: true
  },
  {
    name: DATA_GSUITE_CUSTOM_EMAIL,
    label: 'No',
    value: false
  }
];
const radioItems2 = [
  {
    name: DATA_GSUITE_TRANSFER,
    label: 'Yes',
    value: true
  },
  {
    name: DATA_GSUITE_TRANSFER,
    label: 'No',
    value: false
  }
];

function GSuite({
    email,
    transfer,
    updateDataGSuite
}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`G Suite Emails: 1 / 1`}
      disableButton={isNotChecked(email) || isNotChecked(transfer)}
    >
      <Typography size="Huge" weight={700} marginBottom={24}>
        G Suite Emails
      </Typography>

      <FormGroup>
        <Typography marginBottom={16}>
          Do you currently have custom email addresses?
        </Typography>
        <FlexContainer flexAlign="Between" className={commonStyles.OneToTwo}>
          {radioItems1.map(({ name, label, value }) => (
            <RadioButton
              key={label}
              label={label}
              name={name}
              value={value}
              isSelected={email === value}
              onClick={() => (updateDataGSuite({name, value}))}
            />
          ))}
        </FlexContainer>
      </FormGroup>

      <FormGroup>
        <Typography marginBottom={16}>
          Would you like to transfer them?
        </Typography>
        <FlexContainer flexAlign="Between" className={commonStyles.OneToTwo}>
          {radioItems2.map(({ name, label, value }) => (
            <RadioButton
              key={label}
              label={label}
              name={name}
              value={value}
              isSelected={transfer === value}
              onClick={() => (updateDataGSuite({name, value}))}
            />
          ))}
        </FlexContainer>
      </FormGroup>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  email: state.dataManagement[DATA_GSUITE][DATA_GSUITE_CUSTOM_EMAIL],
  transfer: state.dataManagement[DATA_GSUITE][DATA_GSUITE_TRANSFER]
});

const mapDispatchToProps = dispatch => ({
  updateDataGSuite: payload => dispatch(updateDataGSuite(payload))
});

GSuite.propTypes = {
  email: PropTypes.bool,
  transfer: PropTypes.bool,
  updateDataGSuite: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(GSuite));

