import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateWasDeveloped } from 'stores/dataManagement';

import withFlowManaging from 'helpers/withFlowManaging';
import { DATA_HOSTING_DEVELOPED, DATA_HOSTING } from 'helpers/dmConstants';
import { isNotChecked } from 'helpers';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import FlexContainer from 'components/FlexContainer';
import RadioButton from 'components/RadioButton';

import commonStyles from 'containers/Common.module.scss';

const radioItems = [
  {
    name: DATA_HOSTING_DEVELOPED,
    label: 'Yes',
    value: true
  },
  {
    name: DATA_HOSTING_DEVELOPED,
    label: 'No',
    value: false
  }
];
function Hosting({
   wasDeveloped,
   updateWasDeveloped
}) {

  return (
    <StepWrapper
      isShort
      progressLabel={`Hosting: 1 / 2`}
      disableButton={isNotChecked(wasDeveloped)}
    >
      <Typography size="Huge" weight={700} marginBottom={16}>
        Hosting
      </Typography>
      <Typography marginBottom={16}>
        Did we develop your site?
      </Typography>

      <FlexContainer flexAlign="Between" className={commonStyles.OneToTwo}>
        {radioItems.map(({ name, label, value }) => (
          <RadioButton
            key={label}
            label={label}
            name={name}
            value={value}
            isSelected={wasDeveloped === value}
            onClick={() => (updateWasDeveloped({name, value}))}
          />
        ))}
      </FlexContainer>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  wasDeveloped: state.dataManagement[DATA_HOSTING][DATA_HOSTING_DEVELOPED]
});

const mapDispatchToProps = dispatch => ({
  updateWasDeveloped: payload => dispatch(updateWasDeveloped(payload))
});

Hosting.propTypes = {
  wasDeveloped: PropTypes.bool,
  updateWasDeveloped: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(Hosting));


