import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateDataInput, updateDataAddons } from 'stores/dataManagement';

import withFlowManaging from 'helpers/withFlowManaging';
import {
  DATA_HOSTING,
  DATA_HOSTING_DETAILS,
  DATA_HOSTING_SITE_TYPE,
  DATA_HOSTING_WHERE,
  DATA_HOSTING_MONITORING,
  DATA_HOSTING_PERFORMANCE,
  DATA_HOSTING_TRANSFER,
  DATA_HOSTING_ADDONS,
  DATA_HOSTING_DEVELOPED
} from 'helpers/dmConstants';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import FlexContainer from 'components/FlexContainer';
import FormGroup from 'components/FormGroup';
import Checkbox from 'components/Checkbox';
import MonitoringIcon from 'components/Icons/MonitoringIcon';
import LightningIcon from 'components/Icons/LightningIcon';
import TransferIcon from 'components/Icons/TransferIcon';
import Input from 'components/Input';

import commonStyles from 'containers/Common.module.scss';

const checkboxItems = [
  {
    id: DATA_HOSTING_MONITORING,
    label: 'Website Monitoring',
    icon: <MonitoringIcon />
  },
  {
    id: DATA_HOSTING_PERFORMANCE,
    label: 'Performance Boost',
    icon: <LightningIcon />
  },
  {
    id: DATA_HOSTING_TRANSFER,
    label: 'Hosting Transfer',
    icon: <TransferIcon />
  }
];

function HostingDetails({
  wasDeveloped,
  whereInput,
  typeInput,
  addons,
  updateDataInput,
  updateDataAddons
}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Hosting: 2 / 2`}
    >
      <Typography size="Huge" weight={700} marginBottom={16}>
        Hosting
      </Typography>

      {!wasDeveloped &&
        <>
          <FormGroup>
            <Typography marginBottom={4}>
              Where was your site previously hosted?
            </Typography>
            <Typography isGray size="Tiny" marginBottom={12}>
              If you don&apos;t know, simply leave it blank
            </Typography>
            <Input
              placeholder="e.g. carbonweb.co"
              id={DATA_HOSTING_WHERE}
              value={whereInput}
              onChange={(name, value) => {
                updateDataInput({
                  name,
                  value
                })
              }}
            />
          </FormGroup>

          <FormGroup>
            <Typography marginBottom={4}>
              What type of site do you have?
            </Typography>
            <Typography isGray size="Tiny" marginBottom={12}>
              If you don&apos;t know, simply leave it blank
            </Typography>
            <Input
              placeholder="e.g. online store"
              id={DATA_HOSTING_SITE_TYPE}
              value={typeInput}
              onChange={(name, value) => {
                updateDataInput({
                  name,
                  value
                })
              }}
            />
          </FormGroup>
        </>
      }

      <FormGroup>
        <Typography marginBottom={4}>
          Hosting Add-Ons
        </Typography>
        <Typography isGray size="Tiny" marginBottom={12}>
          Add-Ons to inhance the hosting experience
        </Typography>
        <FlexContainer flexAlign="Between" className={commonStyles.OneToThree}>
          {checkboxItems.map(({id, label, icon}) => (
              <Checkbox
                key={id}
                id={id}
                label={label}
                icon={icon}
                isSelected={addons[id]}
                onClick={() => updateDataAddons(id)}
              />
            ))}
        </FlexContainer>
      </FormGroup>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  whereInput: state.dataManagement[DATA_HOSTING][DATA_HOSTING_DETAILS][DATA_HOSTING_WHERE],
  wasDeveloped: state.dataManagement[DATA_HOSTING][DATA_HOSTING_DEVELOPED],
  typeInput: state.dataManagement[DATA_HOSTING][DATA_HOSTING_DETAILS][DATA_HOSTING_SITE_TYPE],
  addons: state.dataManagement[DATA_HOSTING][DATA_HOSTING_DETAILS][DATA_HOSTING_ADDONS]
});

const mapDispatchToProps = dispatch => ({
  updateDataInput: payload => dispatch(updateDataInput(payload)),
  updateDataAddons: payload => dispatch(updateDataAddons(payload))
});

HostingDetails.propTypes = {
  wasDeveloped: PropTypes.bool,
  whereInput: PropTypes.string,
  typeInput: PropTypes.string,
  addons: PropTypes.object,
  updateDataInput: PropTypes.func,
  updateDataAddons: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(HostingDetails));

