import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import withFlowManaging from 'helpers/withFlowManaging';
import * as CONST from 'helpers/dmConstants';

import { updateDataManagementServices } from 'stores/dataManagement';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import FlexContainer from 'components/FlexContainer';
import Checkbox from 'components/Checkbox';
import HostingIcon from 'components/Icons/HostingIcon';
import DomainIcon from 'components/Icons/DomainIcon';
import GoogleIcon from 'components/Icons/GoogleIcon';
import ReportIcon from 'components/Icons/ReportIcon';

import commonStyles from 'containers/Common.module.scss';

const checkboxItems = [
  {
    id: CONST.DATA_HOSTING,
    label: 'Hosting',
    icon: <HostingIcon/>
  },
  {
    id: CONST.DATA_DOMAINS,
    label: 'Domains',
    icon: <DomainIcon />
  },
  {
    id: CONST.DATA_GSUITE,
    label: 'G Suite Emails',
    icon: <GoogleIcon />
  },
  {
    id: CONST.DATA_REPORTS,
    label: 'Custom Reports',
    icon: <ReportIcon />
  }
];

function DataManagement({
  dataServices,
  updateServices
}) {
  return (
    <StepWrapper
      progressLabel={`Data Management`}
    >
      <Typography size="Huge" weight={700} marginBottom={32}>
        Choose any of the following services:
      </Typography>

      <FlexContainer flexAlign="Between" className={commonStyles.TwoToFour}>
        {checkboxItems.map(({ id, label, icon }) => (
          <Checkbox
            key={id}
            id={id}
            label={label}
            icon={icon}
            isSelected={dataServices[id]}
            onClick={() => updateServices({id, value: !dataServices[id]})}
          />
        ))}
      </FlexContainer>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  dataServices: state.dataManagement.dataServices
});

const mapDispatchToProps = dispatch => ({
  updateServices: payload => dispatch(updateDataManagementServices(payload))
});

DataManagement.propTypes = {
  dataServices: PropTypes.object,
  updateServices: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(DataManagement));


