import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateInputState } from 'stores/webDevelopment';

import withFlowManaging from 'helpers/withFlowManaging';
import { WEB_PAGES_NUM } from 'helpers/constants';
import { isNotChecked } from 'helpers';

import StepWrapper from 'components/StepWrapper';
import FlexContainer from 'components/FlexContainer';
import Typography from 'components/Typography';
import RadioButton from 'components/RadioButton';

import commonStyles from 'containers/Common.module.scss';

const radioItems = [
  {
    name: WEB_PAGES_NUM,
    label: '1-4 Pages',
    value: 'max-4'
  },
  {
    name: WEB_PAGES_NUM,
    label: '4-7 Pages',
    value: 'min-4-max-7'
  },
  {
    name: WEB_PAGES_NUM,
    label: '7+ Pages',
    value: 'min-7'
  },
  {
    name: WEB_PAGES_NUM,
    label: 'Custom',
    value: 'custom'
  }
];

function DevelopmentPages({pages, updatePages}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Web Development:  1 / 3`}
      disableButton={isNotChecked(pages)}
    >
      <Typography marginBottom={32}>
        How many pages would you like on your site?
      </Typography>

      <FlexContainer flexAlign="Between" className={commonStyles.OneToTwo}>
        {radioItems.map(({ name, label, value }) => (
          <RadioButton
            key={label}
            label={label}
            name={name}
            value={value}
            isSelected={pages === value}
            onClick={() => (updatePages({name, value}))}
          />
        ))}
      </FlexContainer>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  pages: state.webDevelopment[WEB_PAGES_NUM]
});

const mapDispatchToProps = dispatch => ({
  updatePages: payload => dispatch(updateInputState(payload))
});

DevelopmentPages.propTypes = {
  pages: PropTypes.string,
  updatePages: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(DevelopmentPages));


