import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateInputState } from 'stores/webDevelopment';

import withFlowManaging from 'helpers/withFlowManaging';
import { WEB_PRODUCTS } from 'helpers/constants';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import Input from 'components/Input';

function DevelopmentShop({products, updateProducts }) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Web Development: 3 / 3`}
    >
      <Typography marginBottom={8}>
        How many products do you plan to have in your online store?
      </Typography>

      <Typography isGray size="Small" weight={400} marginBottom={16}>
        If you don&apos;t know the exact number, please approximate
      </Typography>

      <Input
        type="number"
        placeholder="e.g. 50"
        id={WEB_PRODUCTS}
        value={products}
        onChange={(name, value) => {
          updateProducts({name, value})
        }}
      />
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  products: state.webDevelopment[WEB_PRODUCTS]
});

const mapDispatchToProps = dispatch => ({
  updateProducts: payload => dispatch(updateInputState(payload))
});

DevelopmentShop.propTypes = {
  products: PropTypes.string,
  updateProducts: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(DevelopmentShop));

