import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateHomepageInput } from 'stores/webDevelopment';

import withFlowManaging from 'helpers/withFlowManaging';
import { WEB_HOMEPAGE } from 'helpers/constants';
import { isNotChecked } from 'helpers';

import StepWrapper from 'components/StepWrapper';
import FlexContainer from 'components/FlexContainer';
import Typography from 'components/Typography';
import RadioButton from 'components/RadioButton';

import commonStyles from 'containers/Common.module.scss';

const radioItems = [
  {
    name: WEB_HOMEPAGE,
    label: 'Yes',
    value: true
  },
  {
    name: WEB_HOMEPAGE,
    label: 'No',
    value: false
  }
];

function Development({
  isHomepageWanted,
  updateIsHomepageWanted
}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Web Development`}
      disableButton={isNotChecked(isHomepageWanted)}
    >
      <Typography size="Huge" weight={700} marginBottom={32}>
        Would you like a free homepage mockup?
      </Typography>

      <FlexContainer flexAlign="Between" className={commonStyles.OneToTwo}>
        {radioItems.map(({ name, label, value }) => (
        <RadioButton
          key={label}
          label={label}
          name={name}
          value={value}
          isSelected={isHomepageWanted === value}
          onClick={() => (updateIsHomepageWanted({name, value}))}
        />
        ))}
      </FlexContainer>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  isHomepageWanted: state.webDevelopment[WEB_HOMEPAGE]
});

const mapDispatchToProps = dispatch => ({
    updateIsHomepageWanted: payload => dispatch(updateHomepageInput(payload))
});

Development.propTypes = {
  isHomepageWanted: PropTypes.bool,
  updateIsHomepageWanted: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(Development));
