import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateMainServices } from 'stores/entry';

import withFlowManaging from 'helpers/withFlowManaging';
import { isAnySelected } from 'helpers';
import { CPT, WEB_DEV, DATA, MARKETING } from 'helpers/constants';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import FlexContainer from 'components/FlexContainer';
import Checkbox from 'components/Checkbox';
import PenIcon from 'components/Icons/PenIcon';
import DesktopIcon from 'components/Icons/DesktopIcon';
import WorldIcon from 'components/Icons/WorldIcon';
import ChartIcon from 'components/Icons/ChartIcon';

import commonStyles from 'containers/Common.module.scss';

function Homepage({
  mainServices,
  updateServices
}) {

  const checkboxItems = [
    {
      id: CPT,
      label: 'Concept Production',
      icon: <PenIcon />
    },
    {
      id: WEB_DEV,
      label: 'Web Development',
      icon: <DesktopIcon />
    },
    {
      id: DATA,
      label: 'Data Management',
      icon: <WorldIcon />
    },
    {
      id: MARKETING,
      label: 'Marketing Solution',
      icon: <ChartIcon />
    }
  ];

  return (
    <StepWrapper
      disableButton={isAnySelected(mainServices)}
    >
      <Typography size="Huge" weight={700} marginBottom={32}>
        Choose any of the following services:
      </Typography>

      <FlexContainer flexAlign="Between" className={commonStyles.TwoToFour}>
        {checkboxItems.map(({ id, label, icon }) => (
          <Checkbox
            key={id}
            id={id}
            label={label}
            icon={icon}
            isSelected={mainServices[id]}
            onClick={() => updateServices(id)}
          />
        ))}
      </FlexContainer>
    </StepWrapper>
  );
}

const mapStateToProps = state => {
  return {
    mainServices: state.entry.mainServices
  }
};

const mapDispatchToProps = dispatch => {
  return {
    updateServices: payload => dispatch(updateMainServices(payload))
  }
};

Homepage.propTypes = {
  mainServices: PropTypes.object,
  updateServices: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(Homepage));
