import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import withFlowManaging from 'helpers/withFlowManaging';
import * as CONST from 'helpers/marketingConstants';
import { isNotChecked } from 'helpers';

import { updateAdsInput } from 'stores/marketingSolutions';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import Input from 'components/Input';
import FormGroup from 'components/FormGroup';

function MarketingAdwords({adsUrl, adsBudget, updateAdsInput}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Marketing: Google Ads`}
      disableButton={isNotChecked(adsBudget)}
    >
      <FormGroup>
        <Typography marginBottom={8}>
          Where would you like to bring in traffic?
        </Typography>

        <Typography isGray size="Small" weight={400} marginBottom={16}>
          If you don&apos;t know, simply leave it blank
        </Typography>

        <Input
          type="text"
          placeholder="e.g. www.carbonweb.com"
          id={CONST.MARKETING_GOOGLE_URL}
          value={adsUrl}
          onChange={(id, value) => {
            updateAdsInput({id, value})
          }}
        />
      </FormGroup>

      <FormGroup>
        <Typography marginBottom={8}>
          Please choose your budget
        </Typography>

        <Typography isGray size="Small" weight={400} marginBottom={16}>
          If you don&apos;t know, please try to estimate
        </Typography>

        <Input
          type="number"
          placeholder="e.g. 2,000"
          isCurrencyType
          isMonthlyInterval
          id={CONST.MARKETING_GOOGLE_BUDGET}
          value={adsBudget}
          onChange={(id, value) => {
            updateAdsInput({id, value})
          }}
        />
      </FormGroup>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  adsUrl: state.marketingSolutions[CONST.MARKETING_GOOGLE_ADS][CONST.MARKETING_GOOGLE_URL],
  adsBudget: state.marketingSolutions[CONST.MARKETING_GOOGLE_ADS][CONST.MARKETING_GOOGLE_BUDGET]
});

const mapDispatchToProps = dispatch => ({
  updateAdsInput: payload => dispatch(updateAdsInput(payload))
});

MarketingAdwords.propTypes = {
  adsUrl: PropTypes.string,
  adsBudget: PropTypes.string,
  updateAdsInput: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(MarketingAdwords));

