import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import withFlowManaging from 'helpers/withFlowManaging';
import * as CONST from 'helpers/marketingConstants';
import { isNotChecked } from 'helpers';

import { updateRemarketingPlatforms, updateRemarketingVisitors } from 'stores/marketingSolutions';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import Checkbox from 'components/Checkbox';
import RadioButton from 'components/RadioButton';
import FormGroup from 'components/FormGroup';
import FlexContainer from 'components/FlexContainer';
import FacebookIcon from 'components/Icons/FacebookIcon';
import LinkedinIcon from 'components/Icons/LinkedinIcon';
import GoogleIcon from 'components/Icons/GoogleIcon';

import commonStyles from 'containers/Common.module.scss';

const checkboxItems = [
  {
    name: CONST.MARKETING_REMARKETING_PLATFORMS,
    id: CONST.MARKETING_FACEBOOK,
    label: 'Facebook',
    icon: <FacebookIcon />
  },
  {
    name: CONST.MARKETING_REMARKETING_PLATFORMS,
    id: CONST.MARKETING_LINKEDIN,
    label: 'Linkedin',
    icon: <LinkedinIcon />
  },
  {
    name: CONST.MARKETING_REMARKETING_PLATFORMS,
    id: CONST.MARKETING_GOOGLE,
    label: 'Google',
    icon: <GoogleIcon />
  }
];
const radioItems = [
  {
    name: CONST.MARKETING_REMARKETING_VISITORS,
    value: CONST.MARKETING_REMARKETING_VISITORS_OPTION_1
  },
  {
    name: CONST.MARKETING_REMARKETING_VISITORS,
    value: CONST.MARKETING_REMARKETING_VISITORS_OPTION_2
  },
  {
    name: CONST.MARKETING_REMARKETING_VISITORS,
    value: CONST.MARKETING_REMARKETING_VISITORS_OPTION_3
  },
  {
    name: CONST.MARKETING_REMARKETING_VISITORS,
    value: CONST.MARKETING_REMARKETING_VISITORS_OPTION_4
  }
];

function MarketingRemarketing({
  remarketingPlatforms,
  remarketingVisitors,
  updateRemarketingPlatforms,
  updateRemarketingVisitors
}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Marketing: Digital Remarketing`}
      disableButton={isNotChecked(remarketingVisitors)}
    >
      <FormGroup>
        <Typography marginBottom={16}>
          Which platforms are you interested in remarketing on?
        </Typography>

        <FlexContainer flexAlign="Between" className={commonStyles.OneToThree}>
          {checkboxItems.map(({ id, label, icon, name }) => (
            <Checkbox
              key={name + id}
              id={name + id}
              label={label}
              icon={icon}
              isSelected={remarketingPlatforms[id]}
              onClick={() => updateRemarketingPlatforms({ id, value: !remarketingPlatforms[id]})}
            />
          ))}
        </FlexContainer>
      </FormGroup>

      <FormGroup>
        <Typography marginBottom={16}>
          How many visitors does your site get a month?
        </Typography>

        <FlexContainer flexAlign="Between" className={commonStyles.OneToTwo}>
          {radioItems.map(({ name, value }) => (
            <RadioButton
              key={value}
              label={value}
              name={name}
              value={value}
              isSelected={remarketingVisitors === value}
              onClick={() => (updateRemarketingVisitors({name, value}))}
            />
          ))}
        </FlexContainer>
      </FormGroup>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  remarketingPlatforms:
    state.marketingSolutions[CONST.MARKETING_REMARKETING][CONST.MARKETING_REMARKETING_PLATFORMS],
  remarketingVisitors:
    state.marketingSolutions[CONST.MARKETING_REMARKETING][CONST.MARKETING_REMARKETING_VISITORS]
});

const mapDispatchToProps = dispatch => ({
  updateRemarketingPlatforms: payload => dispatch(updateRemarketingPlatforms(payload)),
  updateRemarketingVisitors: payload => dispatch(updateRemarketingVisitors(payload))
});

MarketingRemarketing.propTypes = {
  remarketingPlatforms: PropTypes.object,
  remarketingVisitors: PropTypes.string,
  updateRemarketingPlatforms: PropTypes.func,
  updateRemarketingVisitors: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(MarketingRemarketing));


