import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import withFlowManaging from 'helpers/withFlowManaging';
import * as CONST from 'helpers/marketingConstants';
import { isNotChecked } from 'helpers';

import { updateMarketingSocialMedia, updatePlatforms } from 'stores/marketingSolutions';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import FormGroup from 'components/FormGroup';
import FlexContainer from 'components/FlexContainer';
import RadioButton from 'components/RadioButton';

import Checkbox from 'components/Checkbox';
import commonStyles from 'containers/Common.module.scss';

import styles from './Marketing.module.scss';
import {
  radioItemsAds,
  radioItemsPosts,
  radioItemsPlan,
  checkboxItemsAds,
  checkboxItemsPosts
} from './marketingSocialMediaInputs';

function MarketingSocialMedia({
  marketingPlan,
  marketingPosts,
  marketingPostsPlatforms,
  marketingAds,
  marketingAdsPlatforms,
  updateMarketingSocialMedia,
  updatePlatforms
}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Marketing: Social Media`}
      disableButton={
        isNotChecked(marketingPlan) ||
        isNotChecked(marketingPosts) ||
        isNotChecked(marketingAds)}
    >
      <FormGroup>
        <Typography marginBottom={16}>
          How long would you like your social media plan to be?
        </Typography>

        <FlexContainer flexAlign="Between" className={commonStyles.OneToTwo}>
          {radioItemsPlan.map(({ name, value }) => (
            <RadioButton
              key={value}
              label={value}
              name={name}
              value={value}
              isSelected={marketingPlan === value}
              onClick={() => (updateMarketingSocialMedia({name, value}))}
            />
          ))}
        </FlexContainer>
      </FormGroup>

      <Typography size="Huge" weight={700} marginBottom={18}>
        Social Media Posts
      </Typography>

      <FormGroup hasSmallerMargin>
        <Typography marginBottom={16}>
          How many posts would you like a month?
        </Typography>

        <FlexContainer flexAlign="Between" className={commonStyles.OneToThree}>
          {radioItemsPosts.map(({ name, value }) => (
            <RadioButton
              key={value}
              label={value}
              name={name}
              value={value}
              isSelected={marketingPosts === value}
              onClick={() => (updateMarketingSocialMedia({name, value}))}
            />
          ))}
        </FlexContainer>
      </FormGroup>

      <FormGroup>
        <Typography marginBottom={16}>
          Please select the platforms you would like to post on
        </Typography>

        <FlexContainer className={styles.OneToFive}>
          {checkboxItemsPosts.map(({ id, label, icon, name }) => (
            <Checkbox
              key={name + id}
              id={name + id}
              label={label}
              icon={icon}
              isSelected={marketingPostsPlatforms[id]}
              onClick={() => updatePlatforms({
                  name, id, value: !marketingPostsPlatforms[id]
              })}
            />
          ))}
        </FlexContainer>
      </FormGroup>

      <Typography size="Huge" weight={700} marginBottom={18}>
        Social Media Ads
      </Typography>

      <FormGroup hasSmallerMargin>
        <Typography marginBottom={16}>
          How many ads would you like a month?
        </Typography>

        <FlexContainer flexAlign="Between" className={commonStyles.OneToTwo}>
          {radioItemsAds.map(({ name, value }) => (
            <RadioButton
              key={value}
              label={value}
              name={name}
              value={value}
              isSelected={marketingAds === value}
              onClick={() => (updateMarketingSocialMedia({name, value}))}
            />
          ))}
        </FlexContainer>
      </FormGroup>

      <FormGroup>
        <Typography marginBottom={16}>
          Please select the ad platforms you would like to use
        </Typography>

        <FlexContainer flexAlign="Between" className={commonStyles.AlwaysTwo}>
          {checkboxItemsAds.map(({ id, label, icon, name }) => (
            <Checkbox
              key={name + id}
              id={name + id}
              label={label}
              icon={icon}
              isSelected={marketingAdsPlatforms[id]}
              onClick={() => updatePlatforms({
                  name, id, value: !marketingAdsPlatforms[id]
              })}
            />
          ))}
        </FlexContainer>
      </FormGroup>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  marketingPlan: state.marketingSolutions[CONST.MARKETING_SM][CONST.MARKETING_SM_PLAN],
  marketingPosts: state.marketingSolutions[CONST.MARKETING_SM][CONST.MARKETING_SM_POSTS],
  marketingPostsPlatforms: state.marketingSolutions[CONST.MARKETING_SM][CONST.MARKETING_POSTS_PLATFORMS],
  marketingAds: state.marketingSolutions[CONST.MARKETING_SM][CONST.MARKETING_SM_ADS],
  marketingAdsPlatforms: state.marketingSolutions[CONST.MARKETING_SM][CONST.MARKETING_ADS_PLATFORMS]
});

const mapDispatchToProps = dispatch => ({
  updateMarketingSocialMedia: payload => dispatch(updateMarketingSocialMedia(payload)),
  updatePlatforms: payload => dispatch(updatePlatforms(payload))
});

MarketingSocialMedia.propTypes = {
  marketingPlan: PropTypes.string,
  marketingPosts: PropTypes.string,
  marketingPostsPlatforms: PropTypes.object,
  marketingAds: PropTypes.string,
  marketingAdsPlatforms: PropTypes.object,
  updateMarketingSocialMedia: PropTypes.func,
  updatePlatforms: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(MarketingSocialMedia));


