import React from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateMarketingServices } from 'stores/marketingSolutions';

import * as CONST from 'helpers/marketingConstants';
import withFlowManaging from 'helpers/withFlowManaging';

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import Checkbox from 'components/Checkbox';
import FlexContainer from 'components/FlexContainer';
import SocialMediaIcon from 'components/Icons/SocialMediaIcon';
import GoogleAdsIcon from 'components/Icons/GoogleAdsIcon';
import MonitoringIcon from 'components/Icons/MonitoringIcon';
import EmailIcon from 'components/Icons/EmailIcon';
import SpeakerIcon from 'components/Icons/SpeakerIcon';

import styles from './Marketing.module.scss';

const checkboxItems = [
  {
    id: CONST.MARKETING_SM,
    label: 'Social Media Management',
    icon: <SocialMediaIcon/>
  },
  {
    id: CONST.MARKETING_GOOGLE_ADS,
    label: 'Google Ads',
    icon: <GoogleAdsIcon />
  },
  {
    id: CONST.MARKETING_YOAST,
    label: 'Yoast SEO',
    icon: <MonitoringIcon />
  },
  {
    id: CONST.MARKETING_HTML_EMAILS,
    label: 'Custom HTML Emails',
    icon: <EmailIcon />
  },
  {
    id: CONST.MARKETING_REMARKETING,
    label: 'Digital Remarketing',
    icon: <SpeakerIcon />
  }
];

function Marketing({marketingServices, updateMarketingServices}) {
  return (
    <StepWrapper
      isShort
      progressLabel={`Marketing`}
    >
      <Typography size="Huge" weight={700} marginBottom={32}>
        Choose any of the following services:
      </Typography>

      <FlexContainer className={styles.OneToFive}>
        {checkboxItems.map(({ id, label, icon }) => (
          <Checkbox
            key={id}
            id={id}
            label={label}
            icon={icon}
            isSelected={marketingServices[id]}
            onClick={() => updateMarketingServices({id, value: !marketingServices[id]})}
          />
        ))}
      </FlexContainer>
    </StepWrapper>
  );
}

const mapStateToProps = state => ({
  marketingServices: state.marketingSolutions.marketingServices
});

const mapDispatchToProps = dispatch => ({
  updateMarketingServices: payload => dispatch(updateMarketingServices(payload))
});

Marketing.propTypes = {
  marketingServices: PropTypes.object,
  updateMarketingServices: PropTypes.func
};

export default connect(mapStateToProps, mapDispatchToProps)(withFlowManaging(Marketing));

