import React, {useEffect} from 'react';
import { connect } from "react-redux";
import PropTypes from "prop-types";

import { resetStore } from "rootReducer";

import StepWrapper from 'components/StepWrapper';
import Typography from 'components/Typography';
import Button from 'components/Button';
import SuccessIcon from 'components/Icons/SuccessIcon';

import styles from './Success.module.scss';

function Success({resetStore}) {
  useEffect(() => {
    resetStore();
  });

  return (
    <StepWrapper isShort withoutBottomNav>
      <div className={styles.SuccessPage}>
        <SuccessIcon className={styles.SuccessIcon} />

        <Typography size="Medium" weight={700} marginBottom={12}>
          Your Carbon Studio Request was successfully sent!
        </Typography>

        <Typography isGray marginBottom={32}>
          We will contact you within 1-2 business days to discuss the next steps
        </Typography>

        <Button className={styles.SuccessButton} label="Go to our website" href="https://www.carbonweb.co" />
      </div>
    </StepWrapper>
  );
}

const mapDispatchToProps = dispatch => {
  return {
    resetStore: () => dispatch(resetStore())
  }
};

Success.propTypes = {
  resetStore: PropTypes.func
};

export default connect(null, mapDispatchToProps)(Success);
