import { ROUTING } from 'routing';

export const generateArrayOfIds = (name, num) => {
  let ids = [];
  for(let i = 0; i < num; i++) {
    ids.push(name+i);
  }
  return ids;
};

// Entry
export const CPT = 'conceptProduction';
export const WEB_DEV = 'webDevelopment';
export const DATA = 'dataManagement';
export const MARKETING = 'marketingSolutions';

// Concept Production
export const CPT_GRAPHICS = 'customGraphics';
export const CPT_LOGO = 'logoCreation';
export const CPT_CONTENT = 'contentCreation';
export const CPT_PHOTO = 'photography';

//Web Development
export const WEB_HOMEPAGE = 'homepageMockup';
export const WEB_PAGES_NUM = 'numberOfPages';
export const WEB_COLORS = 'colorSet';
export const WEB_COLORS_CHOICE = 'color';
export const WEB_WEBSITES = 'examplesOfWebsites';
export const WEB_ADDONS = 'addons';
export const WEB_STORE = 'onlineStore';
export const WEB_PCR = 'pcr';
export const WEB_PLAN = 'updatePlan';
export const WEB_PRODUCTS = 'numberOfProducts';
export const WEB_COLORS_OPTIONS = generateArrayOfIds(WEB_COLORS_CHOICE, 4);

export const MAIN_FLOW_OBLIGATORY_PATHS = [ROUTING.PERSONAL_DETAILS, ROUTING.SUCCESS_PAGE];

export const MAIN_FLOW_SCHEME = {
  [CPT]: ROUTING.CONCEPT_PRODUCTION,
  [WEB_DEV]: ROUTING.WEB_DEVELOPMENT,
  [DATA]: ROUTING.DATA_MANAGEMENT,
  [MARKETING]: ROUTING.MARKETING
};

export const EXTRA_WEB_STEPS = [ROUTING.WEB_DEVELOPMENT_PAGES, ROUTING.WEB_DEVELOPMENT_DETAILS];
