import React from 'react';
import { MAIN_FLOW_SCHEME } from './constants';

// Storybook Helpers
const FlexCenteredStyles = {
  display: 'flex',
  justifyContent: 'center',
  paddingTop: '30px'
};

const CenteredWithMaxWidth = {
  width: '100%',
  maxWidth: '375px',
  margin: '0 auto',
  padding: '24px 0'
};

export const CenterDecorator = storyFn => <div style={FlexCenteredStyles}>{storyFn()}</div>;
export const MaxWidthDecorator = storyFn => <div style={CenteredWithMaxWidth}>{storyFn()}</div>;

// Flow Helpers
export const isSelectionActive = (array) => {
  return array === true;
};

export const isAnySelected = (object) => {
  const selectedItems = Object.values(object);
  return !selectedItems.some(isSelectionActive);
};

export const isAnyEmptyInput = (object) => {
  const inputsValues = Object.values(object);
  return inputsValues.some((item) => item === null);
};

export const isNotChecked = (inputValue) => {
  return inputValue === null;
};

export const getSelected = (object) => (
  Object.keys(object).filter(function(property) {
  return object[property]
  })
);

export const getRelevantToFlow = (selected, flowScheme) => (
  selected.filter(function(item) {
    return Object.prototype.hasOwnProperty.call(flowScheme, item)
  })
);

export const createPathsArray = (servicesObj, flowScheme = MAIN_FLOW_SCHEME) => (
  getRelevantToFlow(getSelected(servicesObj), flowScheme).map((step) => flowScheme[step])
);


