import React, { useEffect } from 'react';
import PropTypes from 'prop-types';
import { connect } from 'react-redux';

import { updateMainFlow } from 'stores/mainFlow';

const withFlowManaging = (Component) => {
  const Sub = ({location, updateMainFlow, ...props}) => {
    useEffect(() => {
      updateMainFlow(location.pathname);
    }, [updateMainFlow, location]);

    return <Component {...props } />;
  };

  Sub.propTypes = {
    updateMainFlow: PropTypes.func,
    location: PropTypes.object
  };

  return connect(null, mapDispatchToProps)(Sub);
};

const mapDispatchToProps = dispatch => ({
  updateMainFlow: payload => dispatch(updateMainFlow(payload))
});

withFlowManaging.propTypes = {
  Component: PropTypes.element
};

export default withFlowManaging;
