import React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { PersistGate } from 'redux-persist/integration/react'
import WebFont from 'webfontloader';
import configureStore from 'store';

import Loader from 'components/Loader';

import App from 'containers/App';

import 'styles/common.scss';

const { store, persistor } = configureStore();

WebFont.load({
  google: {
    families: ['Raleway:400,500,700', 'sans-serif']
  }
});

ReactDOM.render(
  <Provider store={store}>
    <PersistGate loading={<Loader />} persistor={persistor}>
      <App />
    </PersistGate>
  </Provider>,
  document.getElementById('root')
);
