import { combineReducers, createStore } from 'redux';
import entry from 'stores/entry';
import conceptProduction from 'stores/conceptProduction';
import webDevelopment from 'stores/webDevelopment';
import dataManagement from 'stores/dataManagement';
import marketingSolutions from 'stores/marketingSolutions';
import mainFlow from 'stores/mainFlow';
import personalDetails from 'stores/personalDetails';
import api from 'stores/api';

// Actions
const RESET_STORE = 'RESET_STORE';

// Action Creators
export function resetStore() {
  return { type: RESET_STORE };
}

const appReducer = combineReducers({
  entry,
  conceptProduction,
  webDevelopment,
  dataManagement,
  marketingSolutions,
  personalDetails,
  mainFlow,
  api
});

const rootReducer = (state, action) => {
  let newState = state;

  if (action.type === RESET_STORE) {
    const newStore = createStore(appReducer);
    newState = appReducer(newStore.getState(), {});
  }

  return appReducer(newState, action)
};

export default rootReducer;
