// Actions
import { history } from "appHistory";

const SET_HAS_ERROR = 'api.SET_HAS_ERROR';

// Reducer
const initialState = {
  hasError: false
};

// Action Creators
export function setHasError(hasError) {
  return { type: SET_HAS_ERROR, payload: { hasError } };
}

export default function reducer(state = initialState, action) {
  switch (action.type) {
    case SET_HAS_ERROR:
      return {
        ...state.api,
        hasError: action.payload.hasError
      };
    default:
      return state;
  }
}

const SKIPPED_STATE_PARTS = ['api', 'mainFlow', '_persist'];

export function sendData() {
  return async (dispatch, getState) => {
    const allData = {...getState()};

    SKIPPED_STATE_PARTS.map((item) => delete allData[item]);

    const onError = () => {
      dispatch(setHasError(true));
    };

    const onSuccess = () => {
      dispatch(setHasError(false));
      history.push(getState().mainFlow.nextPath);
    };

    try {
      const res = await fetch(`${process.env.REACT_APP_API_URL}/create`, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(allData)
      });

      (res && res.ok) ? onSuccess() : onError();
    } catch (e) {
      onError();
    }
  }
}

