import { CPT_GRAPHICS, CPT_LOGO, CPT_CONTENT, CPT_PHOTO } from 'helpers/constants';

// Actions
export const UPDATE_CPT = 'conceptProduction.UPDATE_CPT';

// Reducer
const initialState = {
  cptServices: {
    [CPT_GRAPHICS]: false,
    [CPT_LOGO]: false,
    [CPT_CONTENT]: false,
    [CPT_PHOTO]: false
  }
};

export default function reducer(state = initialState, action) {
  switch (action.type) {
    case UPDATE_CPT:
      return {
        cptServices: {
          ...state.cptServices,
          [action.payload.id]: action.payload.value
        }
      };
    default:
      return state;
  }
}

// Action Creators
export function updateCptObject({id, value}) {
  return { type: UPDATE_CPT, payload: {id, value} };
}

