import { ROUTING } from 'routing';
import { addToMainFlow, removeFromMainFlow, setNextPath } from './mainFlow';
import { createPathsArray } from 'helpers';
import * as CONST from 'helpers/dmConstants';
import { DATA_DOMAINS_REGISTRATION } from 'helpers/dmConstants';

// Actions
export const UPDATE_DATA_SERVICES = 'dataManagement.UPDATE_DATA_SERVICES';
export const DATA_UPDATE_DEVELOPED = 'dataManagement.DATA_UPDATE_DEVELOPED';
export const DATA_UPDATE_INPUT = 'dataManagement.DATA_UPDATE_INPUT';
export const DATA_UPDATE_ADDONS = 'dataManagement.DATA_UPDATE_ADDONS';
export const DATA_UPDATE_DOMAINS = 'dataManagement.DATA_UPDATE_DOMAINS';
export const DATA_UPDATE_URL = 'dataManagement.DATA_UPDATE_URL';
export const DATA_UPDATE_GSUITE = 'dataManagement.DATA_UPDATE_GSUITE';

// Reducer
const initialState = {
  dataServices: {
    [CONST.DATA_HOSTING]: false,
    [CONST.DATA_DOMAINS]: false,
    [CONST.DATA_GSUITE]: false,
    [CONST.DATA_REPORTS]: false
  },
  [CONST.DATA_HOSTING]: {
    [CONST.DATA_HOSTING_DEVELOPED]: null,
    [CONST.DATA_HOSTING_DETAILS]: {
      [CONST.DATA_HOSTING_WHERE]: null,
      [CONST.DATA_HOSTING_SITE_TYPE]: null,
      [CONST.DATA_HOSTING_ADDONS]:{
        [CONST.DATA_HOSTING_MONITORING]: false,
        [CONST.DATA_HOSTING_PERFORMANCE]: false,
        [CONST.DATA_HOSTING_TRANSFER]: false
      }
    }
  },
  [CONST.DATA_DOMAINS]: {
    [CONST.DATA_DOMAINS_SERVICES]: {
      [CONST.DATA_DOMAINS_SSL]: false,
      [CONST.DATA_DOMAINS_REGISTRATION]: false
    },
    [CONST.DATA_DOMAINS_URL]: null
  },
  [CONST.DATA_GSUITE]: {
    [CONST.DATA_GSUITE_CUSTOM_EMAIL]: null,
    [CONST.DATA_GSUITE_TRANSFER]: null
  }
};

export default function reducer(state = initialState, action) {
  switch (action.type) {
    case UPDATE_DATA_SERVICES:
      return {
        ...state,
        dataServices: {
          ...state.dataServices,
          [action.payload.id]: action.payload.value
        }
      };
    case DATA_UPDATE_DEVELOPED:
      return {
        ...state,
        [CONST.DATA_HOSTING]: {
          ...state[CONST.DATA_HOSTING],
          [action.payload.name]: action.payload.value
        }
      };
    case DATA_UPDATE_INPUT:
      return {
        ...state,
        [CONST.DATA_HOSTING]: {
          ...state[CONST.DATA_HOSTING],
          [CONST.DATA_HOSTING_DETAILS]: {
            ...state[CONST.DATA_HOSTING][CONST.DATA_HOSTING_DETAILS],
            [action.payload.name]: action.payload.value
          }
        }
      };
    case DATA_UPDATE_ADDONS:
      return {
        ...state,
        [CONST.DATA_HOSTING]: {
          ...state[CONST.DATA_HOSTING],
          [CONST.DATA_HOSTING_DETAILS]: {
            ...state[CONST.DATA_HOSTING][CONST.DATA_HOSTING_DETAILS],
            [CONST.DATA_HOSTING_ADDONS]: {
              ...state[CONST.DATA_HOSTING][CONST.DATA_HOSTING_DETAILS][CONST.DATA_HOSTING_ADDONS],
              [action.payload]: !state[CONST.DATA_HOSTING][CONST.DATA_HOSTING_DETAILS][CONST.DATA_HOSTING_ADDONS][action.payload]
            }
          }
        }
      };
    case DATA_UPDATE_DOMAINS:
      return {
        ...state,
        [CONST.DATA_DOMAINS]: {
          ...state[CONST.DATA_DOMAINS],
          [CONST.DATA_DOMAINS_SERVICES]: {
            ...state[CONST.DATA_DOMAINS][CONST.DATA_DOMAINS_SERVICES],
            [action.payload.id]: action.payload.value
          }
        }
      };
    case DATA_UPDATE_URL:
      return {
        ...state,
        [CONST.DATA_DOMAINS]: {
          ...state[CONST.DATA_DOMAINS],
          [action.payload.name]: action.payload.value
        }
      };
    case DATA_UPDATE_GSUITE:
      return {
        ...state,
        [CONST.DATA_GSUITE]: {
          ...state[CONST.DATA_GSUITE],
          [action.payload.name]: action.payload.value
        }
      };
    default:
      return state;
  }
}

// Action Creators
export function updateDmServicesObject({id, value}) {
  return { type: UPDATE_DATA_SERVICES, payload: {id, value} }}

export function updateWasDeveloped({name, value}) {
  return { type: DATA_UPDATE_DEVELOPED, payload: {name, value} }
}

export function updateDataInput({name, value}) {
  return { type: DATA_UPDATE_INPUT, payload: {name, value} }
}

export function updateDataAddons(id) {
  return { type: DATA_UPDATE_ADDONS, payload: id }
}

export function updateDataDomains({id, value}) {
  return { type: DATA_UPDATE_DOMAINS, payload: {id, value} }
}

export function updateDataUrl({name, value}) {
  return { type: DATA_UPDATE_URL, payload: {name, value} }
}

export function updateDataGSuite({name, value}) {
  return { type: DATA_UPDATE_GSUITE, payload: {name, value} }
}

export function updateDataManagementServices({id, value}) {
  return (dispatch, getState) => {
    dispatch(updateDmServicesObject({id, value}));
    if(id in CONST.DM_FLOW) {
      if(value) {
        const extraPaths = createPathsArray(getState().dataManagement.dataServices, CONST.DM_FLOW);
        dispatch(addToMainFlow([].concat.apply([], extraPaths)));
      } else {
        dispatch(removeFromMainFlow([...CONST.DM_FLOW[id]]));
      }
      dispatch(setNextPath());
    }
  }
}

export function updateDataDomainsServcie({id, value}) {
  return (dispatch) => {
    dispatch(updateDataDomains({id, value}));
    if (id === DATA_DOMAINS_REGISTRATION) {
      value ? dispatch(addToMainFlow([ROUTING.DATA_MANAGEMENT_DOMAINS_URL]))
        : dispatch(removeFromMainFlow([ROUTING.DATA_MANAGEMENT_DOMAINS_URL]));
    }
    dispatch(setNextPath());
  }
}
