import { CPT, WEB_DEV, DATA, MARKETING } from 'helpers/constants';
import { createPathsArray } from 'helpers';
import { setCustomMainFlow, setNextPath } from 'stores/mainFlow';

// Actions
export const UPDATE_SERVICES = 'entry.UPDATE_SERVICES';

// Reducer
export const initialState = {
  mainServices: {
    [CPT]: false,
    [WEB_DEV]: false,
    [DATA]: false,
    [MARKETING]: false
  }
};

export default function reducer(state = initialState, action) {
  switch (action.type) {
    case UPDATE_SERVICES:
      return {
        mainServices: {
          ...state.mainServices,
          [action.payload]: !state.mainServices[action.payload]
        }
      };
    default:
      return state;
  }
}

// Action Creators
export function updateServicesObject(id) {
  return { type: UPDATE_SERVICES, payload: id };
}

export function updateMainServices(id) {
  return (dispatch, getState) => {
    dispatch(updateServicesObject(id));
    dispatch(setCustomMainFlow(createPathsArray(getState().entry.mainServices)));
    dispatch(setNextPath());
  }
}

