// Actions
import { MAIN_FLOW_OBLIGATORY_PATHS } from 'helpers/constants';

export const SET_DEFAULT_FLOW = 'mainFlow.SET_DEFAULT_FLOW';
export const SET_CUSTOM_FLOW = 'mainFlow.SET_CUSTOM_FLOW';
export const ADD_TO_FLOW = 'mainFlow.ADD_TO_FLOW';
export const REMOVE_FROM_FLOW = 'mainFlow.REMOVE_FROM_FLOW';
export const SET_FLOW_HELPERS = 'mainFlow.SET_FLOW_HELPERS';
export const SET_NEXT_PATH = 'mainFlow.SET_NEXT_PATH';
export const SET_ENTRY_PATH = 'mainFlow.SET_ENTRY_PATH';

// Reducer
export const initialState = {
  defaultStepsToDo: MAIN_FLOW_OBLIGATORY_PATHS,
  stepsToDo: [],
  currentStep: 0,
  nextPath: null,
  entryPath: null,
  currentPath: null
};

export default function reducer(state = initialState, action) {
  switch (action.type) {
    case SET_DEFAULT_FLOW:
      return {
        ...state,
        entryPath: action.payload,
        stepsToDo: [action.payload, ...state.defaultStepsToDo.filter((item) => item !== action.payload)]
      };
    case SET_CUSTOM_FLOW:
      return {
          ...state,
        stepsToDo: [
          state.entryPath,
          ...action.payload,
          ...state.defaultStepsToDo
        ]
      };
    case ADD_TO_FLOW: {
      let firstPathIndex = null;
      let lastPathIndex = null;
      let finalStepsToDo = [];

      for (let i = 0; i < state.stepsToDo.length; i++) {
        if (state.stepsToDo[i].includes(state.currentPath)) {
          if (firstPathIndex === null) {
            firstPathIndex = i;
          }
          lastPathIndex = i;
        }
      }

      if (firstPathIndex !== null) {
        finalStepsToDo = finalStepsToDo.concat(state.stepsToDo.slice(0, firstPathIndex));
      }
      finalStepsToDo = finalStepsToDo.concat(state.currentPath);
      finalStepsToDo = finalStepsToDo.concat(action.payload);

      if (lastPathIndex !== null) {
        finalStepsToDo = finalStepsToDo.concat(state.stepsToDo.slice(lastPathIndex + 1));
      }

      return {
        ...state,
        stepsToDo: [...finalStepsToDo]
      };
    }
    case REMOVE_FROM_FLOW:
      return {
        ...state,
        stepsToDo: state.stepsToDo.filter(item => !action.payload.includes(item))
      };
    case SET_FLOW_HELPERS:
      return {
        ...state,
        currentPath: action.payload,
        currentStep: state.stepsToDo.indexOf(action.payload)
      };
    case SET_NEXT_PATH:
      return {
        ...state,
        nextPath: state.stepsToDo[state.currentStep + 1]
      };
    default:
      return state;
  }
}

// Action Creators
export function setEntryPath(pathname) {
  return { type: SET_ENTRY_PATH, payload: pathname };
}

export function setDefaultMainFlow(path) {
  return { type: SET_DEFAULT_FLOW, payload: path };
}

export function setCustomMainFlow(paths) {
  return { type: SET_CUSTOM_FLOW, payload: paths };
}

export function addToMainFlow(extraPaths) {
  return { type: ADD_TO_FLOW, payload: extraPaths };
}

export function removeFromMainFlow(extraPaths) {
  return { type: REMOVE_FROM_FLOW, payload: extraPaths };
}

export function setFlowHelpers(path) {
  return { type: SET_FLOW_HELPERS, payload: path };
}

export function setNextPath() {
  return { type: SET_NEXT_PATH };
}
// Side effects

export function updateMainFlow(pathname) {
  return (dispatch, getState) => {
    if(getState().mainFlow.entryPath === null) {
      dispatch(setDefaultMainFlow(pathname));
    }
    dispatch(setFlowHelpers(pathname));
    dispatch(setNextPath());
  }
}





