import * as CONST from 'helpers/marketingConstants';
import { createPathsArray } from 'helpers';
import { addToMainFlow, removeFromMainFlow, setNextPath } from './mainFlow';

// Actions
export const UPDATE_MARKETING_SERVICES = 'marketingSolutions.UPDATE_MARKETING_SERVICES';
export const UPDATE_MARKETING_SM = 'marketingSolutions.UPDATE_MARKETING_SM';
export const UPDATE_MARKETING_PLATFORMS = 'marketingSolutions.UPDATE_MARKETING_PLATFORMS';
export const UPDATE_MARKETING_ADS = 'marketingSolutions.UPDATE_MARKETING_ADS';
export const UPDATE_REMARKETING_PLATFORMS = 'marketingSolutions.UPDATE_REMARKETING_PLATFORMS';
export const UPDATE_REMARKETING_VISITORS = 'marketingSolutions.UPDATE_REMARKETING_VISITORS';

// Reducer
const initialState = {
  marketingServices: {
    [CONST.MARKETING_SM]: false,
    [CONST.MARKETING_GOOGLE_ADS]: false,
    [CONST.MARKETING_YOAST]: false,
    [CONST.MARKETING_HTML_EMAILS]: false,
    [CONST.MARKETING_REMARKETING]: false
  },
  [CONST.MARKETING_SM]: {
    [CONST.MARKETING_SM_PLAN]: null,
    [CONST.MARKETING_SM_POSTS]: null,
    [CONST.MARKETING_POSTS_PLATFORMS]: {
      [CONST.MARKETING_PINTEREST]: false,
      [CONST.MARKETING_TWITTER]: false,
      [CONST.MARKETING_INSTAGRAM]: false,
      [CONST.MARKETING_FACEBOOK]: false,
      [CONST.MARKETING_LINKEDIN]: false
    },
    [CONST.MARKETING_SM_ADS]: null,
    [CONST.MARKETING_ADS_PLATFORMS]: {
      [CONST.MARKETING_TWITTER]: false,
      [CONST.MARKETING_INSTAGRAM]: false,
      [CONST.MARKETING_FACEBOOK]: false,
      [CONST.MARKETING_LINKEDIN]: false
    }
  },
  [CONST.MARKETING_GOOGLE_ADS]: {
    [CONST.MARKETING_GOOGLE_URL]: null,
    [CONST.MARKETING_GOOGLE_BUDGET]: null
  },
  [CONST.MARKETING_REMARKETING]: {
    [CONST.MARKETING_REMARKETING_PLATFORMS]: {
      [CONST.MARKETING_FACEBOOK]: false,
      [CONST.MARKETING_LINKEDIN]: false,
      [CONST.MARKETING_GOOGLE]: false
    },
    [CONST.MARKETING_REMARKETING_VISITORS]: null
  }
};

export default function reducer(state = initialState, action) {
  switch (action.type) {
    case UPDATE_MARKETING_SERVICES:
      return {
        ...state,
        marketingServices: {
          ...state.marketingServices,
          [action.payload.id]: action.payload.value
        }
      };
    case UPDATE_MARKETING_SM:
      return {
        ...state,
        [CONST.MARKETING_SM]: {
          ...state[[CONST.MARKETING_SM]],
          [action.payload.name]: action.payload.value
        }
      };
    case UPDATE_MARKETING_PLATFORMS:
      return {
        ...state,
        [CONST.MARKETING_SM]: {
          ...state[[CONST.MARKETING_SM]],
          [action.payload.name]: {
            ...state[CONST.MARKETING_SM][action.payload.name],
            [action.payload.id]: action.payload.value
          }
        }
      };
    case UPDATE_MARKETING_ADS:
      return {
        ...state,
        [CONST.MARKETING_GOOGLE_ADS]: {
          ...state[[CONST.MARKETING_GOOGLE_ADS]],
          [action.payload.id]: action.payload.value
        }
      };
    case UPDATE_REMARKETING_PLATFORMS:
    return {
      ...state,
      [CONST.MARKETING_REMARKETING]: {
        ...state[CONST.MARKETING_REMARKETING],
        [CONST.MARKETING_REMARKETING_PLATFORMS]: {
          ...state[CONST.MARKETING_REMARKETING][CONST.MARKETING_REMARKETING_PLATFORMS],
          [action.payload.id]: action.payload.value
        }
      }
    };
    case UPDATE_REMARKETING_VISITORS:
      return {
        ...state,
        [CONST.MARKETING_REMARKETING]: {
          ...state[CONST.MARKETING_REMARKETING],
          [action.payload.name]: action.payload.value
        }
      };
    default:
      return state;
  }
}

// Action Creators
export function updateMarketingServicesObject({id, value}) {
  return { type: UPDATE_MARKETING_SERVICES, payload: {id, value} }
}

export function updateMarketingSocialMedia({name, value}) {
  return { type: UPDATE_MARKETING_SM, payload: {name, value} }
}

export function updatePlatforms({name, id, value}) {
  return { type: UPDATE_MARKETING_PLATFORMS, payload: {name, id, value} }
}

export function updateAdsInput({id, value}) {
  return { type: UPDATE_MARKETING_ADS, payload: {id, value} }
}

export function updateRemarketingPlatforms({id, value}) {
  return { type: UPDATE_REMARKETING_PLATFORMS, payload: {id, value} }
}

export function updateRemarketingVisitors({name, value }) {
  return { type: UPDATE_REMARKETING_VISITORS, payload: {name, value} }
}

export function updateMarketingServices({id, value}) {
  return (dispatch, getState) => {
    dispatch(updateMarketingServicesObject({id, value}));
    if(id in CONST.marketingFlow) {
      if(value) {
        const extraPaths = createPathsArray(getState().marketingSolutions.marketingServices, CONST.marketingFlow);
        dispatch(addToMainFlow([].concat.apply([], extraPaths)));
      } else {
        dispatch(removeFromMainFlow([...CONST.marketingFlow[id]]));
      }
      dispatch(setNextPath());
    }
  }
}
