import {
  PD_FORM,
  PD_EMAIL,
  PD_PHONE,
  PD_NAME,
  PD_COMPANY_NAME,
  PD_COMPANY_ADDRESS,
  PD_FINDOUT,
  PD_FINDOUT_OTHER_INPUT,
  PD_TIME_ZONE,
  PD_WEBSITE
} from 'helpers/personalDetailsConstants';

// Actions
export const UPDATE_PD_INPUT = 'personalDetails.UPDATE_PD_INPUT';

// Reducer
export const initialState = {
  [PD_FORM]: {
    [PD_EMAIL]: null,
    [PD_NAME]: null,
    [PD_PHONE]: null,
    [PD_COMPANY_NAME]: null,
    [PD_COMPANY_ADDRESS]: null,
    [PD_WEBSITE]: null,
    [PD_FINDOUT]: null,
    [PD_FINDOUT_OTHER_INPUT]: '',
    [PD_TIME_ZONE]: null
  }
};

export default function reducer(state = initialState, action) {
  switch (action.type) {
    case UPDATE_PD_INPUT:
      return {
        ...state,
        [PD_FORM]: {
          ...state[PD_FORM],
          [action.payload.id]: action.payload.value
        }
      };
    default:
      return state;
  }
}

// Action Creators
export function updatePersonalDetailsInput(id) {
  return { type: UPDATE_PD_INPUT, payload: id };
}
