import {
  WEB_HOMEPAGE,
  WEB_PAGES_NUM,
  WEB_COLORS,
  WEB_COLORS_OPTIONS,
  WEB_WEBSITES,
  WEB_ADDONS,
  WEB_STORE,
  WEB_PCR,
  WEB_PLAN,
  WEB_PRODUCTS,
  EXTRA_WEB_STEPS
} from 'helpers/constants';
import { setNextPath, addToMainFlow, removeFromMainFlow } from './mainFlow';
import { ROUTING } from 'routing';

// Actions
export const WEB_UPDATE_INPUT = 'webDevelopment.WEB_UPDATE_INPUT';
export const WEB_UPDATE_COLORS = 'webDevelopment.WEB_UPDATE_COLORS';
export const WEB_UPDATE_ADDONS = 'webDevelopment.WEB_UPDATE_ADDONS';

// Reducer
const initialState = {
    [WEB_HOMEPAGE]: null,
    [WEB_PAGES_NUM]: null,
    [WEB_COLORS]: {
      [WEB_COLORS_OPTIONS[0]]: null,
      [WEB_COLORS_OPTIONS[1]]: null,
      [WEB_COLORS_OPTIONS[2]]: null,
      [WEB_COLORS_OPTIONS[3]]: null
    },
    [WEB_WEBSITES]: null,
    [WEB_ADDONS]: {
      [WEB_STORE]: false,
      [WEB_PCR]: false,
      [WEB_PLAN]: false
    },
    [WEB_PRODUCTS]: null
};

export default function reducer(state = initialState, action) {
  switch (action.type) {
    case WEB_UPDATE_INPUT:
      return {
        ...state,
        [action.payload.name]: action.payload.value
      };
    case WEB_UPDATE_COLORS:
      return {
        ...state,
        [WEB_COLORS]: {
          ...state[WEB_COLORS],
          [action.payload.id]: action.payload.hex
        }
      };
    case WEB_UPDATE_ADDONS:
      return {
        ...state,
        [WEB_ADDONS]: {
          ...state[WEB_ADDONS],
          [action.payload.name]: action.payload.value
        }
      };
    default:
      return state;
  }
}

// Action Creators
export function updateInputState({name, value}) {
  return { type: WEB_UPDATE_INPUT, payload: {name, value} };
}

export function updateColorsObj({id, hex}) {
  return { type: WEB_UPDATE_COLORS, payload: {id, hex}};
}

export function updateAddonsObj({name, value}) {
  return { type: WEB_UPDATE_ADDONS, payload: {name, value}};
}

export function updateHomepageInput({name, value}) {
  return (dispatch) => {
    dispatch(updateInputState({name, value}));
    value ? dispatch(addToMainFlow(EXTRA_WEB_STEPS)) : dispatch(removeFromMainFlow(EXTRA_WEB_STEPS));
    dispatch(setNextPath());
  }
}

export function updateWebsiteAddons({name, value}) {
  return (dispatch) => {
    dispatch(updateAddonsObj({name, value}));
    if (name === WEB_STORE) {
      value ? dispatch(addToMainFlow([ROUTING.WEB_DEVELOPMENT_SHOP])) : dispatch(removeFromMainFlow([ROUTING.WEB_DEVELOPMENT_SHOP]));
    }
    dispatch(setNextPath());
  }
}
